/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import com.google.common.base.Predicate;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomNpcs;
import noppes.npcs.ICompatibilty;
import noppes.npcs.LogWriter;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.Server;
import noppes.npcs.VersionCompatibility;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.api.handler.data.IQuestCategory;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumQuestCompletion;
import noppes.npcs.constants.EnumQuestRepeat;
import noppes.npcs.constants.EnumQuestTask;
import noppes.npcs.constants.EnumRewardType;
import noppes.npcs.constants.EnumSync;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.FactionOptions;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.QuestCategory;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.quests.QuestInterface;
import noppes.npcs.quests.QuestObjective;
import noppes.npcs.util.Util;
import noppes.npcs.util.ValueUtil;

public class Quest
implements ICompatibilty,
IQuest,
Predicate<EntityNPCInterface> {
    public boolean cancelable = false;
    public boolean showProgressInChat = true;
    public boolean showProgressInWindow = true;
    public boolean showRewardText = true;
    public int id = -1;
    public int level = 0;
    public int nextQuest = -1;
    public int rewardExp = 0;
    public int rewardMoney = 0;
    public int step = 0;
    public int extraButton = 0;
    public int version = VersionCompatibility.ModRev;
    public int[] forgetDialogues = new int[0];
    public int[] forgetQuests = new int[0];
    public int[] completerPos = new int[]{0, 0, 0, 0};
    public String command = "";
    public String completeText = "";
    public String logText = "";
    public String nextQuestTitle = "";
    public String rewardText = "";
    public String title = "default";
    public String extraButtonText = "";
    public QuestCategory category;
    public FactionOptions factionOptions = new FactionOptions();
    public ResourceLocation icon = new ResourceLocation("customnpcs", "textures/quest icon/q_0.png");
    public ResourceLocation texture = null;
    public PlayerMail mail = new PlayerMail();
    public QuestInterface questInterface = new QuestInterface();
    public NpcMiscInventory rewardItems = new NpcMiscInventory(9);
    public EnumQuestRepeat repeat = EnumQuestRepeat.NONE;
    public EnumQuestCompletion completion = EnumQuestCompletion.Npc;
    public EnumRewardType rewardType = EnumRewardType.RANDOM_ONE;
    public EntityNPCInterface completer = null;
    private UUID completerUUID = null;

    public Quest(QuestCategory categoryIn) {
        this.category = categoryIn;
    }

    @Override
    public IQuestObjective addTask() {
        return this.questInterface.addTask(EnumQuestTask.ITEM);
    }

    public boolean apply(EntityNPCInterface entity) {
        return this.completerUUID == null || entity.func_110124_au().equals(this.completerUUID);
    }

    public boolean complete(EntityPlayer player, QuestData data) {
        if (this.completion == EnumQuestCompletion.Instant) {
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.QUEST_COMPLETION, data.quest.id);
            return true;
        }
        return false;
    }

    public Quest copy() {
        Quest quest = new Quest(this.category);
        quest.load(this.save(new NBTTagCompound()));
        return quest;
    }

    @Override
    public IQuestCategory getCategory() {
        return this.category;
    }

    @Override
    public ICustomNpc<?> getCompleterNpc() {
        if (this.completer == null) {
            return null;
        }
        return (ICustomNpc)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)this.completer);
    }

    @Override
    public String getCompleteText() {
        return this.completeText;
    }

    @Override
    public int getExtraButton() {
        return this.extraButton;
    }

    @Override
    public String getExtraButtonText() {
        return this.extraButtonText;
    }

    @Override
    public int[] getForgetDialogues() {
        return this.forgetDialogues;
    }

    @Override
    public int[] getForgetQuests() {
        return this.forgetQuests;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean getIsRepeatable() {
        return this.repeat != EnumQuestRepeat.NONE;
    }

    public String getKey() {
        char c = '\u00a7';
        return c + "7ID:" + this.id + c + "8" + this.category.title + "/" + c + "7 \"" + c + "5" + this.getTitle() + c + "7\"";
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public String getLogText() {
        StringBuilder allTextLogs = new StringBuilder();
        String ent = "\n";
        LinkedHashMap<ItemStack, Integer> rewardMap = new LinkedHashMap<ItemStack, Integer>();
        for (int i = 0; i < this.rewardItems.func_70302_i_(); ++i) {
            ItemStack item = this.rewardItems.func_70301_a(i);
            if (item.func_190926_b()) continue;
            boolean has = false;
            if (this.rewardType == EnumRewardType.ALL) {
                for (ItemStack it : rewardMap.keySet()) {
                    if (!item.func_77969_a(it) || !ItemStack.areItemStackShareTagsEqual((ItemStack)item, (ItemStack)it)) continue;
                    rewardMap.compute(it, (k, c) -> c == null ? item.func_190916_E() : c + item.func_190916_E());
                    has = true;
                    break;
                }
            }
            if (has) continue;
            rewardMap.put(item, item.func_190916_E());
        }
        if (this.showRewardText) {
            if (!rewardMap.isEmpty() || this.rewardExp > 0 || this.rewardMoney > 0 || !this.rewardText.isEmpty()) {
                allTextLogs.append(ent).append(ent).append(new TextComponentTranslation("questlog.reward", new Object[0]).func_150254_d());
            }
            if (!rewardMap.isEmpty()) {
                allTextLogs.append(ent).append(new TextComponentTranslation("questlog." + (this.rewardType == EnumRewardType.ONE_SELECT ? "one" : (this.rewardType == EnumRewardType.RANDOM_ONE ? "rnd" : "all")) + ".reward", new Object[0]).func_150254_d());
                int j = 1;
                for (ItemStack item : rewardMap.keySet()) {
                    int c2 = (Integer)rewardMap.get(item);
                    allTextLogs.append(ent).append(rewardMap.size() > 1 ? j + " - " : "").append(" ").append('\uffff').append(" ").append(item.func_82833_r()).append(c2 > 1 ? " x" + c2 : "");
                    ++j;
                }
            }
            if (this.rewardMoney > 0) {
                allTextLogs.append(ent).append(new TextComponentTranslation("questlog.rewardmoney", new Object[]{Util.instance.getTextReducedNumber(this.rewardMoney, true, true, false), CustomNpcs.displayCurrencies}).func_150254_d());
            }
            if (this.rewardExp > 0) {
                allTextLogs.append(ent).append(new TextComponentTranslation("questlog.rewardexp", new Object[]{"" + this.rewardExp}).func_150254_d());
            }
        }
        if (!this.rewardText.isEmpty()) {
            allTextLogs.append(ent).append(this.rewardText.contains("%") ? this.rewardText : new TextComponentTranslation(this.rewardText, new Object[0]).func_150254_d());
        }
        if (!this.logText.isEmpty()) {
            allTextLogs.append(ent).append(ent).append('\u00a7').append("l").append(new TextComponentTranslation("gui.description", new Object[0]).func_150254_d()).append(ent).append(this.logText.contains("%") ? this.logText : new TextComponentTranslation(this.logText, new Object[0]).func_150254_d());
        }
        return allTextLogs.toString();
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public Quest getNextQuest() {
        return QuestController.instance == null ? null : QuestController.instance.quests.get(this.nextQuest);
    }

    public QuestObjective[] getObjectives(EntityPlayer player) {
        if (player == null) {
            return new QuestObjective[0];
        }
        PlayerData data = PlayerData.get(player);
        if (data == null || !data.questData.activeQuests.containsKey(this.id)) {
            return new QuestObjective[0];
        }
        return this.questInterface.getObjectives(player);
    }

    @Override
    public IQuestObjective[] getObjectives(IPlayer<?> player) {
        if (!player.hasActiveQuest(this.id)) {
            throw new CustomNPCsException("Player doesnt have this quest active.", new Object[0]);
        }
        return this.questInterface.getObjectives((EntityPlayer)player.getMCEntity());
    }

    @Override
    public IContainer getRewards() {
        return Objects.requireNonNull(NpcAPI.Instance()).getIContainer(this.rewardItems);
    }

    @Override
    public int getRewardType() {
        return this.rewardType.ordinal();
    }

    @Override
    public String getTitle() {
        String key = "";
        if (this.level > 0) {
            String chr = "\u00a7";
            key = chr + (this.level <= CustomNpcs.MaxLv / 3 ? "2" : ((float)this.level <= (float)CustomNpcs.MaxLv / 1.5f ? "e" : "c"));
            key = key + this.level + chr + "7 Lv.: " + chr + "r";
        }
        key = key + new TextComponentTranslation(this.title, new Object[0]).func_150254_d();
        return key;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public boolean hasCompassSettings() {
        for (QuestObjective task : this.questInterface.tasks) {
            if (task.rangeCompass <= 3 || task.pos.func_177958_n() == 0 || task.pos.func_177956_o() == 0 || task.pos.func_177952_p() == 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasNewQuest() {
        return this.getNextQuest() != null;
    }

    @Override
    public boolean isCancelable() {
        return this.cancelable;
    }

    @Override
    public boolean isSetUp() {
        if (this.questInterface.tasks.length == 0) {
            return false;
        }
        for (QuestObjective task : this.questInterface.tasks) {
            if (!(task.getEnumType() == EnumQuestTask.ITEM || task.getEnumType() == EnumQuestTask.CRAFT ? task.getItemStack().func_190926_b() : task.getEnumType() == EnumQuestTask.DIALOG && DialogController.instance.dialogs.get(task.getTargetID()) == null)) continue;
            return false;
        }
        return true;
    }

    public void load(NBTTagCompound compound) {
        this.id = compound.func_74762_e("Id");
        this.loadPartial(compound);
    }

    public void loadPartial(NBTTagCompound compound) {
        this.version = compound.func_74762_e("ModRev");
        VersionCompatibility.CheckAvailabilityCompatibility(this, compound);
        this.title = compound.func_74779_i("Title");
        this.logText = compound.func_74779_i("Text");
        this.completeText = compound.func_74779_i("CompleteText");
        this.command = compound.func_74779_i("QuestCommand");
        this.nextQuest = compound.func_74762_e("NextQuestId");
        this.rewardExp = compound.func_74762_e("RewardExp");
        this.rewardItems.load(compound.func_74775_l("Rewards"));
        this.completion = EnumQuestCompletion.values()[compound.func_74762_e("QuestCompletion")];
        this.repeat = EnumQuestRepeat.values()[compound.func_74762_e("QuestRepeat")];
        this.questInterface.readEntityFromNBT(compound, this.id);
        this.factionOptions.load(compound.func_74775_l("QuestFactionPoints"));
        this.mail.readNBT(compound.func_74775_l("QuestMail"));
        this.rewardType = EnumRewardType.values()[compound.func_74762_e("RewardType")];
        this.rewardMoney = compound.func_74762_e("RewardMoney");
        this.nextQuestTitle = compound.func_74779_i("NextQuestTitle");
        this.nextQuestTitle = this.hasNewQuest() ? this.getNextQuest().title : "";
        this.icon = compound.func_150297_b("QuestIcon", 8) ? new ResourceLocation(compound.func_74779_i("QuestIcon")) : new ResourceLocation("customnpcs", "textures/quest icon/q_0.png");
        this.texture = compound.func_150297_b("QuestTexture", 8) ? new ResourceLocation(compound.func_74779_i("QuestTexture")) : null;
        this.extraButtonText = compound.func_74779_i("ExtraButtonText");
        this.level = compound.func_74762_e("QuestLevel");
        this.cancelable = compound.func_74767_n("Cancelable");
        if (compound.func_150297_b("ShowProgressInChat", 1)) {
            this.showProgressInChat = compound.func_74767_n("ShowProgressInChat");
        }
        if (compound.func_150297_b("ShowProgressInWindow", 1)) {
            this.showProgressInWindow = compound.func_74767_n("ShowProgressInWindow");
        }
        if (compound.func_150297_b("ShowRewardText", 1)) {
            this.showRewardText = compound.func_74767_n("ShowRewardText");
        }
        this.setExtraButton(compound.func_74762_e("ExtraButton"));
        this.rewardText = compound.func_74779_i("AddRewardText");
        this.step = compound.func_74762_e("Step") % 3;
        if (this.step < 0) {
            this.step *= -1;
        }
        this.forgetDialogues = compound.func_74759_k("ForgetDialogues");
        this.forgetQuests = compound.func_74759_k("ForgetQuests");
        this.completer = null;
        this.completerUUID = null;
        if (compound.func_150297_b("CompleterPos", 11)) {
            this.completerPos = compound.func_74759_k("CompleterPos");
        }
        try {
            Entity e;
            String name = compound.func_74775_l("CompleterNpc").func_74779_i("Name");
            if (compound.func_150297_b("CompleterNpc", 8)) {
                name = compound.func_74779_i("CompleterNpc");
            } else if (compound.func_150297_b("CompleterNpc", 10) && compound.func_74775_l("CompleterNpc").func_150297_b("UUIDMost", 4) && compound.func_74775_l("CompleterNpc").func_150297_b("UUIDLeast", 4)) {
                this.completerUUID = compound.func_74775_l("CompleterNpc").func_186857_a("UUID");
            }
            World[] worlds = new World[]{};
            if (CustomNpcs.Server != null) {
                worlds = CustomNpcs.Server.field_71305_c;
            } else if (CustomNpcs.proxy.getPlayer() != null) {
                worlds = new World[]{CustomNpcs.proxy.getPlayer().field_70170_p};
            }
            for (World world : worlds) {
                for (EntityNPCInterface entity : world.func_175644_a(EntityNPCInterface.class, (Predicate)this)) {
                    if (!entity.func_70005_c_().equals(name)) continue;
                    this.completer = entity;
                    if (this.completerUUID != null) break;
                    this.completerUUID = entity.func_110124_au();
                    break;
                }
                if (this.completer != null) break;
            }
            if (this.completer == null && worlds.length > 0 && worlds[0] != null && (e = EntityList.func_75615_a((NBTTagCompound)compound.func_74775_l("CompleterNpc"), (World)worlds[0])) instanceof EntityNPCInterface) {
                this.completer = (EntityNPCInterface)e;
                this.completerUUID = e.func_110124_au();
            }
        }
        catch (Throwable t) {
            LogWriter.error("Error: ", t);
        }
    }

    @Override
    public boolean removeTask(IQuestObjective task) {
        return this.questInterface.removeTask((QuestObjective)task);
    }

    @Override
    public void save() {
        QuestController.instance.saveQuest(this.category, this);
    }

    @Override
    @SideOnly(value=Side.SERVER)
    public void sendChangeToAll() {
        Server.sendToAll(CustomNpcs.Server, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.QuestData, this.save(new NBTTagCompound()), this.category.id});
    }

    @Override
    public void setCancelable(boolean cancelableIn) {
        this.cancelable = cancelableIn;
    }

    @Override
    public void setCompleterNpc(ICustomNpc<?> npc) {
        this.completer = (EntityNPCInterface)((Object)npc.getMCEntity());
    }

    @Override
    public void setCompleteText(String text) {
        this.completeText = text;
    }

    @Override
    public void setExtraButton(int type) {
        if (type < 0) {
            type *= -1;
        }
        this.extraButton = type % 6;
    }

    @Override
    public void setExtraButtonText(String hover) {
        this.extraButtonText = hover == null ? "" : hover;
    }

    @Override
    public void setForgetDialogues(int[] forget) {
        this.forgetDialogues = forget;
    }

    @Override
    public void setForgetQuests(int[] forget) {
        this.forgetQuests = forget;
    }

    @Override
    public void setLevel(int levelIn) {
        if (levelIn < 0) {
            levelIn *= -1;
        }
        this.level = ValueUtil.correctInt(levelIn, 1, CustomNpcs.MaxLv);
    }

    @Override
    public void setLogText(String text) {
        this.logText = text;
    }

    @Override
    public void setName(String name) {
        this.title = name;
    }

    @Override
    public void setNextQuest(IQuest quest) {
        if (quest == null) {
            this.nextQuest = -1;
            this.nextQuestTitle = "";
        } else {
            if (quest.getId() < 0) {
                throw new CustomNPCsException("Quest id is lower than 0", new Object[0]);
            }
            this.nextQuest = quest.getId();
            this.nextQuestTitle = quest.getTitle();
        }
    }

    @Override
    public void setRewardText(String text) {
        this.rewardText = text;
    }

    @Override
    public void setRewardType(int type) {
        if (type < 0 || type >= EnumRewardType.values().length) {
            return;
        }
        this.rewardType = EnumRewardType.values()[type];
    }

    @Override
    public void setVersion(int versionIn) {
        this.version = versionIn;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        compound.func_74768_a("Id", this.id);
        return this.saveToPartial(compound);
    }

    public NBTTagCompound saveToPartial(NBTTagCompound compound) {
        compound.func_74768_a("ModRev", this.version);
        compound.func_74778_a("Title", this.title);
        compound.func_74778_a("Text", this.logText);
        compound.func_74778_a("CompleteText", this.completeText);
        compound.func_74768_a("NextQuestId", this.nextQuest);
        compound.func_74768_a("RewardExp", this.rewardExp);
        compound.func_74782_a("Rewards", (NBTBase)this.rewardItems.save());
        compound.func_74778_a("QuestCommand", this.command);
        compound.func_74768_a("QuestCompletion", this.completion.ordinal());
        compound.func_74768_a("QuestRepeat", this.repeat.ordinal());
        this.questInterface.writeEntityToNBT(compound);
        compound.func_74782_a("QuestFactionPoints", (NBTBase)this.factionOptions.save(new NBTTagCompound()));
        compound.func_74782_a("QuestMail", (NBTBase)this.mail.writeNBT());
        compound.func_74778_a("NextQuestTitle", this.nextQuestTitle);
        compound.func_74768_a("RewardMoney", this.rewardMoney);
        compound.func_74778_a("QuestIcon", this.icon.toString());
        if (this.texture != null) {
            compound.func_74778_a("QuestTexture", this.texture.toString());
        }
        compound.func_74768_a("RewardType", this.rewardType.ordinal());
        compound.func_74768_a("QuestLevel", this.level);
        compound.func_74757_a("Cancelable", this.cancelable);
        compound.func_74757_a("ShowProgressInChat", this.showProgressInChat);
        compound.func_74757_a("ShowProgressInWindow", this.showProgressInWindow);
        compound.func_74757_a("ShowRewardText", this.showRewardText);
        compound.func_74778_a("ExtraButtonText", this.extraButtonText);
        compound.func_74768_a("ExtraButton", this.extraButton);
        compound.func_74778_a("AddRewardText", this.rewardText);
        compound.func_74768_a("Step", this.step);
        compound.func_74783_a("ForgetDialogues", this.forgetDialogues);
        compound.func_74783_a("ForgetQuests", this.forgetQuests);
        if (this.completer != null) {
            NBTTagCompound npcNbt = new NBTTagCompound();
            this.completer.func_70039_c(npcNbt);
            compound.func_74782_a("CompleterNpc", (NBTBase)npcNbt);
            if (this.completerPos[0] == 0 && this.completerPos[1] == 0 && this.completerPos[2] == 0 && this.completerPos[3] == 0) {
                this.completerPos[0] = (int)this.completer.field_70165_t;
                this.completerPos[1] = (int)(this.completer.field_70163_u + 0.5);
                this.completerPos[2] = (int)this.completer.field_70161_v;
                this.completerPos[3] = this.completer.field_70170_p.field_73011_w.getDimension();
            }
        }
        compound.func_74783_a("CompleterPos", this.completerPos);
        return compound;
    }
}

